# Big5 LCD Font test -- 2018/10/24 tklua@wifiboy.org

# Big5 List: http://web.tnu.edu.tw/me/study/moodle/tutor/vb6/tutor/r05/index.htm
# Big5 Translate: http://billor.chsh.chc.edu.tw/php/Tools/qBig5.php
'''
0x8140-0xA0FE 	保留給使用者自訂字元（造字區）
0xA140-0xA3BF 	標點符號、希臘字母及特殊符號，
0xA3C0-0xA3FE 	保留。此區沒有開放作造字區用。
0xA440-0xC67E 	常用漢字，先按筆劃再按部首排序。
0xC6A1-0xC8FE 	保留給使用者自訂字元（造字區）
0xC940-0xF9D5 	次常用漢字，亦是先按筆劃再按部首排序。
0xF9D6-0xFEFE 	保留給使用者自訂字元（造字區） 
'''

def b5offset(x):
    x1 = x >> 8
    x2 = x %256
    n=(x1-161)*2826+148
    if (x2<127):n+=(x2-64)*18
    else: n+=(x2-98)*18
    return n

def showb5(b, x, y, c):
    count = 0
    cx=x
    for i in range(18):
        for j in range(4):
            if b[i]&(2**(7-j)): wb.pix(cx, y, c); 
            cx+=1
        count+=1
        if count % 3 == 0: cx=x; y+=1
        for j in range(4):
            if b[i]&(2**(3-j)): wb.pix(cx, y, c); 
            cx+=1
        count+=1
        if count % 3 == 0: cx=x; y+=1
            
b5str = [0xA4D1, 0xA455, 0xB54C, 0xC3F8, 0xA8C6]            
posx, posy = 20, 30
color = wb.WHITE

wb.cls()
with open("/sd/font/FB512F.PDB", "rb") as f:
    for ch in b5str:
    	f.seek(b5offset(ch))
        showb5(f.read(18), posx, posy, color)
        posx += 14
    f.close()
    